#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QTimer>
#include <dc1394/dc1394.h>
#include <QDoubleSpinBox>
 #include <QCheckBox>

namespace Ui
{
    class Dc1394Dialog;
}

class Dc1394Dialog : public QMainWindow
{
    Q_OBJECT

public:
    Dc1394Dialog(dc1394camera_t *camera =0, QWidget *parent = 0);
    ~Dc1394Dialog();

private:
    Ui::Dc1394Dialog *ui;

    dc1394camera_t *camera;
    dc1394video_frame_t *frame;
    dc1394featureset_t features;

    int timer;
    bool initialize();
    void setupFeature(QString name, dc1394feature_t feature, QDoubleSpinBox *spin);
    void updateFeature(dc1394feature_t feature, QDoubleSpinBox *spin, QCheckBox *checkbox);

private slots:
    void on_manualBrightness_toggled(bool checked);
    void on_autoShutter_clicked();
    void on_shutterSpin_valueChanged(double );
    void on_manualShutter_toggled(bool checked);
    void on_whiteBalSliderRed_sliderMoved(int position);
    void on_whiteBalSliderBlue_sliderMoved(int position);
    void on_manualWhiteBal_toggled(bool checked);
    void on_manualExposure_toggled(bool checked);
    void on_autoExposure_clicked();
    void on_exposureSpin_valueChanged(double );
    void timerEvent( QTimerEvent * );
    void on_gainSpin_valueChanged(int );
    void on_manualGain_toggled(bool checked);
    void on_autoGain_clicked();
};

#endif // MAINWINDOW_H
