//CN[hK[h
#ifndef __KINECTV2_H__
#define __KINECTV2_H__

#define _CRT_SECURE_NO_WARNINGS 
#include <Kinect.h>
#include <stdio.h>
#include <vector>

#include <opencv2/opencv.hpp>

#include <pcl/point_types.h> 
#include <pcl/visualization/cloud_viewer.h> // opencv̌include
#include <pcl/io/pcd_io.h>
#include <pcl/ModelCoefficients.h> 

class KinectV2
{
private: 
	///ӂ̕ϐ͕ύXȂ///
	IKinectSensor* pSensor;
	HRESULT hResult;
	ICoordinateMapper* pCoordinateMapper;
	IColorFrameSource* pColorSource;
	IDepthFrameSource* pDepthSource;
	IColorFrameReader* pColorReader;
	IDepthFrameReader* pDepthReader;
	IFrameDescription* pColorDescription;
	int colorWidth;
	int colorHeight;
	std::vector<RGBQUAD> colorBuffer;
	IFrameDescription* pDepthDescription;
	int depthWidth;
	int depthHeight;
	std::vector<UINT16> depthBuffer;
	std::vector<DepthSpacePoint> depthSpace;
	IDepthFrame* pDepthFrame;
	

	///loɎgp///
	IBodyIndexFrameSource* pBodyIndexSource;
	IBodyIndexFrameReader* pBodyIndexReader;
	IFrameDescription* pBodyDescription;
	IBodyIndexFrame* pBodyIndexFrame;

	IBodyFrameReader* pBodyReader;
	IBodyFrameSource* pBodySource;
	IBodyFrame* pBodyFrame;
	IColorFrame* pColorFrame;


	///_QۂɎgp///
	bool updatePointcloud;
	pcl::PointCloud<pcl::PointXYZRGB>::Ptr pointcloud;
	pcl::visualization::CloudViewer *viewer;


	///J[Ƌ摜̈ʒu킹///
	CameraSpacePoint* cameraSpacePointsInColorIndex;
	CameraSpacePoint* cameraSpacePointsInDepthIndex;
	

	cv::Mat colorImage;
	cv::Mat depthImage;
	cv::Mat rawdepthImage;
	cv::Mat DepthsizeColor;
	cv::Mat ColorsizeDepth;

public: 
	KinectV2();
	KinectV2(cv::Mat argDepthImg);

	~KinectV2(); 
	 
	int RenewColorFrame();
	int ShowColorImg();
	int RenewDepthFrame();
	int ShowDepthImg();
	int RenewPointCloud();
	int ShowPointCloud();

	cv::Mat GetColorImage();
	cv::Mat GetDepthImage();
	cv::Mat GetRawDepthImage();
	cv::Mat GetColorSizeDepth();
	cv::Mat GetDepthSizeColor();

	pcl::PointCloud<pcl::PointXYZRGB>::Ptr KinectV2::GetPointCloud();
};


#endif __KINECTV2_H__