#include "KinectV2.h"

template<class Interface>
inline void SafeRelease(Interface *& pInterfaceToRelease)
{
	if (pInterfaceToRelease != NULL) {
		pInterfaceToRelease->Release();
		pInterfaceToRelease = NULL;
	}
}

//RXgN^
KinectV2::KinectV2()
{

	hResult = S_OK;
	hResult = GetDefaultKinectSensor(&pSensor);
	if (FAILED(hResult)) {
		std::cerr << "Error : GetDefaultKinectSensor" << std::endl;
		//return -1;
	}

	hResult = pSensor->Open();
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::Open()" << std::endl;
		//return -1;
	}

	hResult = pSensor->get_CoordinateMapper(&pCoordinateMapper);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_CoordinateMapper()" << std::endl;
		//return -1;
	}

	hResult = pSensor->get_ColorFrameSource(&pColorSource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_ColorFrameSource()" << std::endl;
		//return -1;
	}

	hResult = pSensor->get_DepthFrameSource(&pDepthSource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_DepthFrameSource()" << std::endl;
		//return -1;
	}

	hResult = pColorSource->OpenReader(&pColorReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IColorFrameSource::OpenReader()" << std::endl;
		//return -1;
	}

	hResult = pDepthSource->OpenReader(&pDepthReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IDepthFrameSource::OpenReader()" << std::endl;
		//return -1;
	}

	hResult = pColorSource->get_FrameDescription(&pColorDescription);
	if (FAILED(hResult)) {
		std::cerr << "Error : IColorFrameSource::get_FrameDescription()" << std::endl;
		//return -1;
	}

	colorWidth = 0;
	colorHeight = 0;
	pColorDescription->get_Width(&colorWidth); // 1920
	pColorDescription->get_Height(&colorHeight); // 1080

	colorBuffer.resize(colorWidth * colorHeight);


	hResult = pDepthSource->get_FrameDescription(&pDepthDescription);
	if (FAILED(hResult)) {
		std::cerr << "Error : IDepthFrameSource::get_FrameDescription()" << std::endl;
		//return -1;
	}

	depthWidth = 0;
	depthHeight = 0;
	pDepthDescription->get_Width(&depthWidth); // 512
	pDepthDescription->get_Height(&depthHeight); // 424

	depthBuffer.resize(depthWidth * depthHeight);

	pointcloud = pcl::PointCloud<pcl::PointXYZRGB>::Ptr(new pcl::PointCloud<pcl::PointXYZRGB>);

	pointcloud->width = static_cast<uint32_t>(depthWidth);
	pointcloud->height = static_cast<uint32_t>(depthHeight);
	pointcloud->is_dense = false;
	pointcloud->resize(pointcloud->width * pointcloud->height);


	hResult = pSensor->get_BodyIndexFrameSource(&pBodyIndexSource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_BodyIndexFrameSource()" << std::endl;
		//return -1;
	}

	// Reader

	hResult = pBodyIndexSource->OpenReader(&pBodyIndexReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IBodyIndexFrameSource::OpenReader()" << std::endl;
		//return -1;
	}

	// Description

	hResult = pBodyIndexSource->get_FrameDescription(&pBodyDescription);
	if (FAILED(hResult)) {
		std::cerr << "Error : IBodyIndexFrameSource::get_FrameDescription()" << std::endl;
		//return -1;
	}

	hResult = pSensor->get_BodyFrameSource(&pBodySource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_BodyFrameSource()" << std::endl;
		//return -1;
	}


	hResult = pBodySource->OpenReader(&pBodyReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IBodyFrameSource::OpenReader()" << std::endl;
		//return -1;
	}


	updatePointcloud = false;

}


KinectV2::KinectV2(cv::Mat argDepthImg)
{
	// Create Sensor Instance

	hResult = S_OK;
	hResult = GetDefaultKinectSensor(&pSensor);
	if (FAILED(hResult)) {
		std::cerr << "Error : GetDefaultKinectSensor" << std::endl;
	}

	// Open Sensor
	hResult = pSensor->Open();
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::Open()" << std::endl;
	}

	// Retrieved Coordinate Mapper

	hResult = pSensor->get_CoordinateMapper(&pCoordinateMapper);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_CoordinateMapper()" << std::endl;
	}

	// Retrieved Color Frame Source

	hResult = pSensor->get_ColorFrameSource(&pColorSource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_ColorFrameSource()" << std::endl;
	}

	// Retrieved Depth Frame Source

	hResult = pSensor->get_DepthFrameSource(&pDepthSource);
	if (FAILED(hResult)) {
		std::cerr << "Error : IKinectSensor::get_DepthFrameSource()" << std::endl;
	}

	// Open Color Frame Reader

	hResult = pColorSource->OpenReader(&pColorReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IColorFrameSource::OpenReader()" << std::endl;
	}

	// Open Depth Frame Reader

	hResult = pDepthSource->OpenReader(&pDepthReader);
	if (FAILED(hResult)) {
		std::cerr << "Error : IDepthFrameSource::OpenReader()" << std::endl;
	}

	// Retrieved Color Frame Size

	hResult = pColorSource->get_FrameDescription(&pColorDescription);
	if (FAILED(hResult)) {
		std::cerr << "Error : IColorFrameSource::get_FrameDescription()" << std::endl;
	}

	colorWidth = 0;
	colorHeight = 0;
	pColorDescription->get_Width(&colorWidth); // 1920
	pColorDescription->get_Height(&colorHeight); // 1080

												 // To Reserve Color Frame Buffer
	colorBuffer.resize(colorWidth * colorHeight);

	// Retrieved Depth Frame Size

	hResult = pDepthSource->get_FrameDescription(&pDepthDescription);
	if (FAILED(hResult)) {
		std::cerr << "Error : IDepthFrameSource::get_FrameDescription()" << std::endl;
	}
	depthWidth = 0;
	depthHeight = 0;
	pDepthDescription->get_Width(&depthWidth); // 512
	pDepthDescription->get_Height(&depthHeight); // 424

	depthSpace.resize(colorWidth * colorHeight);
	depthBuffer.resize(depthWidth * depthHeight);


	cameraSpacePointsInColorIndex = new CameraSpacePoint;

	cameraSpacePointsInDepthIndex = new CameraSpacePoint;

}


KinectV2::~KinectV2()
{
	SafeRelease(pColorSource);
	SafeRelease(pDepthSource);
	SafeRelease(pColorReader);
	SafeRelease(pDepthReader);
	SafeRelease(pColorDescription);
	SafeRelease(pDepthDescription);
	SafeRelease(pCoordinateMapper);
	if (pSensor) {
		pSensor->Close();
	}
	SafeRelease(pSensor);

}



int KinectV2::ShowColorImg()
{
	while (1) {
		RenewColorFrame();
		cv::imshow("colorimage", colorImage);
		cv::waitKey(1);
	}
	return 0;
}



//////int KinectV2::ShowDepthImg()̖O, 摜\֐/////
//////kinectV2.hɂ֐̐錾ĒuKv//////
int KinectV2::ShowDepthImg()
{
	
}

int KinectV2::RenewColorFrame()
{
	// Acquire Latest Color Frame
	IColorFrame* pColorFrame = nullptr;
	hResult = pColorReader->AcquireLatestFrame(&pColorFrame);
	if (SUCCEEDED(hResult)) {
		// Retrieved Color Data
		hResult = pColorFrame->CopyConvertedFrameDataToArray(colorBuffer.size() * sizeof(RGBQUAD), reinterpret_cast<BYTE*>(&colorBuffer[0]), ColorImageFormat::ColorImageFormat_Bgra);
		if (FAILED(hResult)) {
			std::cerr << "Error : IColorFrame::CopyConvertedFrameDataToArray()" << std::endl;
			return -1;
		}
	}
	SafeRelease(pColorFrame);

	colorImage = cv::Mat(cv::Size(colorWidth, colorHeight), CV_8UC4, reinterpret_cast<BYTE*>(&colorBuffer[0]));

	return 0;
}


int KinectV2::RenewDepthFrame()
{
	// Acquire Latest Depth Frame
	IDepthFrame* pDepthFrame = nullptr;
	hResult = pDepthReader->AcquireLatestFrame(&pDepthFrame);
	if (SUCCEEDED(hResult)) {
		// Retrieved Depth Data
		hResult = pDepthFrame->CopyFrameDataToArray(depthBuffer.size(), &depthBuffer[0]);
		if (FAILED(hResult)) {
			std::cerr << "Error : IDepthFrame::CopyFrameDataToArray()" << std::endl;
		}
	}
	SafeRelease(pDepthFrame);

	//////// ///////
	////////@NXϐ̐ݒ聨kinectV2.hprivate"depthImg"̖OMat^̕ϐǉ////////
	////////AJ[摜̎擾֐QlɊ({colordepthɕς邾)////
	//= cv::Mat(cv::Size(/*EEE*/, /*EEE*/), CV_16UC1, reinterpret_cast<BYTE*>(/*EEE*/));

	return 0;
}

cv::Mat KinectV2::GetColorImage()
{
	// Acquire Latest Color Frame
	IColorFrame* pColorFrame = nullptr;
	hResult = pColorReader->AcquireLatestFrame(&pColorFrame);
	if (SUCCEEDED(hResult)) {
		// Retrieved Color Data
		hResult = pColorFrame->CopyConvertedFrameDataToArray(colorBuffer.size() * sizeof(RGBQUAD), reinterpret_cast<BYTE*>(&colorBuffer[0]), ColorImageFormat::ColorImageFormat_Bgra);
		if (FAILED(hResult)) {
			std::cerr << "Error : IColorFrame::CopyConvertedFrameDataToArray()" << std::endl;
		}
	}
	SafeRelease(pColorFrame);
	colorImage = cv::Mat(cv::Size(colorWidth, colorHeight), CV_8UC4, reinterpret_cast<BYTE*>(&colorBuffer[0]));

	//RGBAXP[RGBXP[ւ̕ϊ
	cv::cvtColor(colorImage, colorImage, CV_RGBA2RGB);

	return colorImage;
}

cv::Mat KinectV2::GetDepthImage()
{
	// Acquire Latest Depth Frame
	IDepthFrame* pDepthFrame = nullptr;
	hResult = pDepthReader->AcquireLatestFrame(&pDepthFrame);
	if (SUCCEEDED(hResult)) {
		// Retrieved Depth Data
		hResult = pDepthFrame->CopyFrameDataToArray(depthBuffer.size(), &depthBuffer[0]);
		if (FAILED(hResult)) {
			std::cerr << "Error : IDepthFrame::CopyFrameDataToArray()" << std::endl;
		}
	}
	SafeRelease(pDepthFrame);
	
	depthImage = cv::Mat(cv::Size(depthWidth, depthHeight), CV_16UC1, reinterpret_cast<BYTE*>(&depthBuffer[0]));
	// Scaling ( 0-8000 -> 255-0 )
	cv::Mat scaleMat;
	depthImage.convertTo(scaleMat, CV_8U, -255.0 / 8000.0, 255.0);

	return scaleMat;
}

cv::Mat KinectV2::GetRawDepthImage()
{
	cv::Mat RawdepthImage;
	// Acquire Latest Depth Frame
	IDepthFrame* pDepthFrame = nullptr;
	hResult = pDepthReader->AcquireLatestFrame(&pDepthFrame);
	if (SUCCEEDED(hResult)) {
		// Retrieved Depth Data
		hResult = pDepthFrame->CopyFrameDataToArray(depthBuffer.size(), &depthBuffer[0]);
		if (FAILED(hResult)) {
			std::cerr << "Error : IDepthFrame::CopyFrameDataToArray()" << std::endl;
		}
	}
	SafeRelease(pDepthFrame);
	RawdepthImage = cv::Mat(cv::Size(depthWidth, depthHeight), CV_16UC1, (&depthBuffer[0]));
	return RawdepthImage;
}



cv::Mat KinectV2::GetDepthSizeColor()
{
	// Retrieve Mapped Coordinates
	std::vector<ColorSpacePoint> colorSpacePoints(depthWidth * depthHeight);
	pCoordinateMapper->MapDepthFrameToColorSpace(depthBuffer.size(), &depthBuffer[0], colorSpacePoints.size(), &colorSpacePoints[0]);
	int colorBytesPerPixel = 4;
	// Mapped Color Buffer
	std::vector<BYTE> buffer(depthWidth * depthHeight * colorBytesPerPixel);

	// Mapping Color Data to Depth Resolution
	for (int depthY = 0; depthY < depthHeight; depthY++) {
		for (int depthX = 0; depthX < depthWidth; depthX++) {
			const unsigned int depthIndex = depthY * depthWidth + depthX;
			const int colorX = static_cast<int>(colorSpacePoints[depthIndex].X + 0.5f);
			const int colorY = static_cast<int>(colorSpacePoints[depthIndex].Y + 0.5f);
			if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)) {
				const unsigned int colorIndex = colorY * colorWidth + colorX;
				buffer[depthIndex * colorBytesPerPixel + 0] = colorBuffer[colorIndex].rgbBlue;
				buffer[depthIndex * colorBytesPerPixel + 1] = colorBuffer[colorIndex].rgbGreen;
				buffer[depthIndex * colorBytesPerPixel + 2] = colorBuffer[colorIndex].rgbRed;
				buffer[depthIndex * colorBytesPerPixel + 3] = colorBuffer[colorIndex].rgbReserved;
			}
		}
	}

	
	// e.g. Mapped Color Buffer to cv::Mat
	cv::Mat colorMat = cv::Mat( depthHeight, depthWidth, CV_8UC4, &buffer[0] ).clone();

	//RGBAXP[RGBXP[ւ̕ϊ
	cv::cvtColor(colorMat, colorMat, CV_RGBA2RGB);

	return colorMat;
	
}



cv::Mat KinectV2::GetColorSizeDepth()
{
	bool flag = false;
	RenewColorFrame();
	RenewDepthFrame();
	updatePointcloud = true;

	// Retrieve Mapped Coordinates
	std::vector<DepthSpacePoint> depthSpacePoints(colorWidth * colorHeight);
	pCoordinateMapper->MapColorFrameToDepthSpace(depthBuffer.size(), &depthBuffer[0], depthSpacePoints.size(), &depthSpacePoints[0]);

	// Mapped Depth Buffer
	std::vector<UINT16> buffer(colorWidth * colorHeight);

	// Mapping Depth Data to Color Resolution
	for (int colorY = 0; colorY < colorHeight; colorY++) {
		for (int colorX = 0; colorX < colorWidth; colorX++) {
			const unsigned int colorIndex = colorY * colorWidth + colorX;
			const int depthX = static_cast<int>(depthSpacePoints[colorIndex].X + 0.5f);
			const int depthY = static_cast<int>(depthSpacePoints[colorIndex].Y + 0.5f);
			if ((0 <= depthX) && (depthX < depthWidth) && (0 <= depthY) && (depthY < depthHeight)) {
				const unsigned int depthIndex = depthY * depthWidth + depthX;
				buffer[colorIndex] = depthBuffer[depthIndex];
				flag = true;
			}
		}
	}
	cv::Mat depthMat = cv::Mat(colorHeight, colorWidth, CV_16UC1, &buffer[0]).clone();
	return depthMat;

}


int KinectV2::RenewPointCloud()
{
	//cv::Mat WorldsDepth = cv::Mat(cv::Size(512, 424), CV_8UC3);
	RenewColorFrame();
	RenewDepthFrame();
	updatePointcloud = true;
	for (int y = 0; y < depthHeight; y++){
		for (int x = 0; x < depthWidth; x++){
			pcl::PointXYZRGB point;

			//̓_
			DepthSpacePoint depthSpacePoint = { static_cast<float>(x), static_cast<float>(y) };
			//depthbuffer ɍŐṼt[depthl
			UINT16 depth = depthBuffer[y * depthWidth + x];

			// Coordinate Mapping Depth to Color Space, and Setting PointCloud RGB
			//̓_
			ColorSpacePoint colorSpacePoint = { 0.0f, 0.0f };
			//depth摜ƃJ[摜̏ꏊ킹
			pCoordinateMapper->MapDepthPointToColorSpace(depthSpacePoint, depth, &colorSpacePoint);
			//color摜
			int colorX = static_cast<int>(std::floor(colorSpacePoint.X + 0.5f));
			int colorY = static_cast<int>(std::floor(colorSpacePoint.Y + 0.5f));
			if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)){
				RGBQUAD color = colorBuffer[colorY * colorWidth + colorX];
				point.b = color.rgbBlue;
				point.g = color.rgbGreen;
				point.r = color.rgbRed;
			}


			// Coordinate Mapping Depth to Camera Space, and Setting PointCloud XYZ
			CameraSpacePoint cameraSpacePoint = { 0.0f, 0.0f, 0.0f };
			pCoordinateMapper->MapDepthPointToCameraSpace(depthSpacePoint, depth, &cameraSpacePoint);
			if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)){
				point.x = cameraSpacePoint.X;
				point.y = cameraSpacePoint.Y;
				point.z = cameraSpacePoint.Z;

				pointcloud->points[y * depthWidth + x] = point;

			}
			else {
				pointcloud->points[y * depthWidth + x].x = std::numeric_limits<float>::quiet_NaN();
				pointcloud->points[y * depthWidth + x].y = std::numeric_limits<float>::quiet_NaN();
				pointcloud->points[y * depthWidth + x].z = std::numeric_limits<float>::quiet_NaN();
			}
		}
	}
	return 0;
}

int KinectV2::ShowPointCloud()
{
	pcl::visualization::PCLVisualizer viewer("Point Cloud Viewer");
	while (1) {
		RenewPointCloud();
		pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> inputRGB(pointcloud);
		if (!viewer.updatePointCloud(pointcloud, inputRGB)) {
			viewer.addPointCloud(pointcloud, inputRGB);
		}
		viewer.spinOnce(100);
	}

	return 0;
}
//cv::Mat KinectV2::RenewPointCloud(int n, double *Average, double *SubAverage, double *ZoomAverage, double *sumAverage, int *num, int *subnum, int *zoomnum, double *MidValue, cv::Mat colorImage)
//{
//	updatePointcloud = true;
//	cv::Mat src(540 * 420, 3, CV_32F);
//	int Anum = 0;
//	int Asubnum = 0;
//	int Azoomnum = 0;
//	double maxX = -10000;
//	double minX = 10000;
//	double maxY = -10000;
//	double minY = 10000;
//
//	*num = 0;
//	*subnum = 0;
//	*zoomnum = 0;
//	Average[0] = 0;
//	Average[1] = 0;
//	Average[2] = 0;
//	SubAverage[0] = 0;
//	SubAverage[1] = 0;
//	SubAverage[2] = 0;
//	ZoomAverage[0] = 0;
//	ZoomAverage[1] = 0;
//	sumAverage[0] = 0;
//	sumAverage[1] = 0;
//	sumAverage[2] = 0;
//	MidValue[0] = 0;
//	MidValue[1] = 0;
//	MidValue[2] = 0;
//	for (int y = 0; y < depthHeight; y++) {
//
//		for (int x = 0; x < depthWidth; x++) {
//			
//			cv::Vec3b colorVec;
//			DepthSpacePoint depthSpacePoint = { static_cast<float>(x), static_cast<float>(y) };
//			UINT16 depth = depthBuffer[y * depthWidth + x];
//
//			ColorSpacePoint colorSpacePoint = { 0.0f, 0.0f };
//			pCoordinateMapper->MapDepthPointToColorSpace(depthSpacePoint, depth, &colorSpacePoint);
//
//			int colorX = static_cast<int>(std::floor(colorSpacePoint.X + 0.5f));
//			int colorY = static_cast<int>(std::floor(colorSpacePoint.Y + 0.5f));
//			if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)) {
//
//				
//				colorVec = colorImage.at<cv::Vec3b>(colorY * 1920 + colorX);
//
//			}
//			CameraSpacePoint cameraSpacePoint = { 0.0f, 0.0f, 0.0f };
//			pCoordinateMapper->MapDepthPointToCameraSpace(depthSpacePoint, depth, &cameraSpacePoint);
//
//			if (n == 0) {
//				if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)) {
//					if (colorVec[0] == 255 && colorVec[1] == 0 && colorVec[2] == 0) {
//
//						src.at<float>(Anum, 0) = cameraSpacePoint.X;
//						src.at<float>(Anum, 1) = cameraSpacePoint.Y;
//						src.at<float>(Anum, 2) = cameraSpacePoint.Z;
//
//						Average[0] += src.at<float>(Anum, 0);
//						Average[1] += src.at<float>(Anum, 1);
//						Average[2] += src.at<float>(Anum, 2);
//
//						if (src.at<float>(Anum, 0) > maxX) {
//							maxX = src.at<float>(Anum, 0);
//						}
//						else if (src.at<float>(Anum, 0) < minX) {
//							minX = src.at<float>(Anum, 0);
//						}
//
//						if (src.at<float>(Anum, 1) > maxY) {
//							maxY = src.at<float>(Anum, 1);
//						}
//						else if (src.at<float>(Anum, 1) < minY) {
//							minY = src.at<float>(Anum, 1);
//						}
//
//						Anum++;
//					}
//					else if (colorVec[0] == 0 && colorVec[1] == 100 && colorVec[2] == 100) {
//						SubAverage[0] += cameraSpacePoint.X;
//						SubAverage[1] += cameraSpacePoint.Y;
//						SubAverage[2] += cameraSpacePoint.Z;
//						Asubnum++;
//					}
//
//				}
//			}
//			else if (n == 1) {
//				if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)) {
//					if (colorVec[0] == 0 && colorVec[1] == 0 && colorVec[2] == 255) {
//						src.at<float>(Anum, 0) = cameraSpacePoint.X;
//						src.at<float>(Anum, 1) = cameraSpacePoint.Y;
//						src.at<float>(Anum, 2) = cameraSpacePoint.Z;
//						Average[0] += cameraSpacePoint.X;
//						Average[1] += cameraSpacePoint.Y;
//						Average[2] += cameraSpacePoint.Z;
//						if (src.at<float>(Anum, 0) > maxX) {
//							maxX = src.at<float>(Anum, 0);
//						}
//						else if (src.at<float>(Anum, 0) < minX) {
//							minX = src.at<float>(Anum, 0);
//						}
//
//						if (src.at<float>(Anum, 1) > maxY) {
//							maxY = src.at<float>(Anum, 1);
//						}
//						else if (src.at<float>(Anum, 1) < minY) {
//							minY = src.at<float>(Anum, 1);
//						}
//						Anum++;
//					}
//					else if (colorVec[0] == 100 && colorVec[1] == 100 && colorVec[2] == 0) {
//						SubAverage[0] += cameraSpacePoint.X;
//						SubAverage[1] += cameraSpacePoint.Y;
//						SubAverage[2] += cameraSpacePoint.Z;
//						Asubnum++;
//
//					}
//				}
//			}
//			else {
//				if ((0 <= colorX) && (colorX < colorWidth) && (0 <= colorY) && (colorY < colorHeight)) {
//					if (colorVec[0] == 0 && colorVec[1] == 255 && colorVec[2] == 0) {
//						src.at<float>(Anum, 0) = cameraSpacePoint.X;
//						src.at<float>(Anum, 1) = cameraSpacePoint.Y;
//						src.at<float>(Anum, 2) = cameraSpacePoint.Z;
//						Average[0] += cameraSpacePoint.X;
//						Average[1] += cameraSpacePoint.Y;
//						Average[2] += cameraSpacePoint.Z;
//						if (src.at<float>(Anum, 0) > maxX) {
//							maxX = src.at<float>(Anum, 0);
//						}
//						else if (src.at<float>(Anum, 0) < minX) {
//							minX = src.at<float>(Anum, 0);
//						}
//
//						if (src.at<float>(Anum, 1) > maxY) {
//							maxY = src.at<float>(Anum, 1);
//						}
//						else if (src.at<float>(Anum, 1) < minY) {
//							minY = src.at<float>(Anum, 1);
//						}
//						Anum++;
//					}
//					else if (colorVec[0] == 100 && colorVec[1] == 0 && colorVec[2] == 100) {
//						SubAverage[0] += cameraSpacePoint.X;
//						SubAverage[1] += cameraSpacePoint.Y;
//						SubAverage[2] += cameraSpacePoint.Z;
//						Asubnum++;
//					}
//				}
//			}
//		}
//	}
//
//	*num = Anum;
//	*subnum = Asubnum;
//	*zoomnum = Azoomnum;
//	Average[0] = Average[0] / *num;
//	Average[1] = Average[1] / *num;
//	Average[2] = Average[2] / *num;
//
//	SubAverage[0] = SubAverage[0] / *subnum;
//	SubAverage[1] = SubAverage[1] / *subnum;
//	SubAverage[2] = SubAverage[2] / *subnum;
//	
//
//	MidValue[0] = (maxX + minX) / 2;
//	MidValue[1] = (maxY + minY) / 2;
//
//	src.resize(*num);
//	return src;
//}

pcl::PointCloud<pcl::PointXYZRGB>::Ptr KinectV2::GetPointCloud()
{
	return pointcloud;
}

//int KinectV2::InitializePointCloud(cv::Mat color, cv::Mat depth)
//{
//	for (int y = 0; y < depth.cols; y++) {
//		for (int x = 0; x < depth.rows; x++) {
//
//			pcl::PointXYZRGB point;
//			point.rgb = (0, 0, 0);
//			point.x = 0;
//			point.y = 0;
//			point.z = 0;
//			pointcloud->points[x * depth.rows + y] = point;
//		}
//	}
//	return 0;
//}






