#include <pcl/io/pcd_io.h>
#include <pcl/point_types.h>
#include <pcl/filters/voxel_grid.h>
#include <pcl/visualization/pcl_visualizer.h>
#include <boost/thread/thread.hpp>
#include <pcl/registration/icp.h>
#include <time.h>
#include <pcl/features/fpfh.h>
#include <pcl/features/normal_3d.h>
#include <pcl/registration/ia_ransac.h>


void VoxelgridFiltering(const std::string pathToSrc, const std::string pathToDst, const float leafSize = 0.01f);
void VoxelgridFiltering(const std::string pathToSrc, const std::string pathToDst, const float leafSizeX, const float leafSizeY, const float leafSizeZ);
void FPFH(pcl::PointCloud<pcl::PointXYZRGB> source, pcl::PointCloud<pcl::PointXYZRGB> target);
void ICP(const pcl::PointCloud<pcl::PointXYZRGB> source, const pcl::PointCloud<pcl::PointXYZRGB> target, const std::string pathToFile);
//void ICPWithNormals(pcl::PointCloud<pcl::PointXYZRGB> source, pcl::PointCloud<pcl::PointXYZRGB> target);