#include "pcl_functions.h"


// {NZObhtB^
// pathToSrc   ͓_Q̃t@C
// pathToDst   tB^O̓_Q̃t@C
// leafSize    tB^O̓x
void VoxelgridFiltering(const std::string pathToSrc, const std::string pathToDst, const float leafSize)
{
	pcl::PCLPointCloud2::Ptr src(new pcl::PCLPointCloud2 ());
	pcl::PCLPointCloud2::Ptr dst(new pcl::PCLPointCloud2 ());

	pcl::PCDReader reader;
	reader.read(pathToSrc, *src);

	// Create the filtering object
	pcl::VoxelGrid<pcl::PCLPointCloud2> sor;
	sor.setInputCloud(src);
	sor.setLeafSize(leafSize, leafSize, leafSize);
	
	sor.filter(*dst);
	pcl::io::savePCDFile(pathToDst, *dst);

	return;
}

// {NZObhtB^
// pathToSrc   ͓_Q̃t@C
// pathToDst   tB^O̓_Q̃t@C
// leafSizeX,Y,Z  X,Y,Zꂼ̃̕tB^O̓x
void VoxelgridFiltering(const std::string pathToSrc, const std::string pathToDst, const float leafSizeX, const float leafSizeY, const float leafSizeZ)
{
	pcl::PCLPointCloud2::Ptr src(new pcl::PCLPointCloud2 ());
	pcl::PCLPointCloud2::Ptr dst(new pcl::PCLPointCloud2 ());

	pcl::PCDReader reader;
	reader.read(pathToSrc, *src);

	// Create the filtering object
	pcl::VoxelGrid<pcl::PCLPointCloud2> sor;
	sor.setInputCloud(src);
	sor.setLeafSize(leafSizeX, leafSizeY, leafSizeZ);
	
	sor.filter(*dst);
	pcl::io::savePCDFile(pathToDst, *dst);

	return;
}

void FPFH(pcl::PointCloud<pcl::PointXYZRGB> source, pcl::PointCloud<pcl::PointXYZRGB> target){

	const double NORMR = 0.03;
	const double FPFHR = 0.08;

	
	//////////////////////////FPFH


	//input1 - FPFHZo cloud[0]
	printf("fpfh1\n");
	pcl::NormalEstimation<pcl::PointXYZRGB, pcl::Normal> ne;
	ne.setInputCloud(source.makeShared());
	pcl::search::KdTree<pcl::PointXYZRGB>::Ptr tree_nom (new pcl::search::KdTree<pcl::PointXYZRGB>());
	ne.setSearchMethod(tree_nom);
	pcl::PointCloud<pcl::Normal>::Ptr normals (new pcl::PointCloud<pcl::Normal>);
	ne.setRadiusSearch(NORMR); // a
	ne.compute(*normals);

	pcl::FPFHEstimation<pcl::PointXYZRGB, pcl::Normal, pcl::FPFHSignature33> fpfh;
	fpfh.setInputCloud(source.makeShared());
	fpfh.setInputNormals(normals);
	pcl::search::KdTree<pcl::PointXYZRGB>::Ptr tree_fpfh (new pcl::search::KdTree<pcl::PointXYZRGB>());
	fpfh.setSearchMethod(tree_fpfh);
	pcl::PointCloud<pcl::FPFHSignature33>::Ptr fpfhs (new pcl::PointCloud<pcl::FPFHSignature33> ());
	fpfh.setRadiusSearch(FPFHR); //a
	fpfh.compute(*fpfhs);
	printf("fpfh1 done\n");

	//input2 - FPFHZo cloud[1]
	printf("fpfh2\n");
	pcl::NormalEstimation<pcl::PointXYZRGB, pcl::Normal> ne2;
	ne2.setInputCloud(target.makeShared());
	pcl::search::KdTree<pcl::PointXYZRGB>::Ptr tree_nom2 (new pcl::search::KdTree<pcl::PointXYZRGB>());
	ne2.setSearchMethod(tree_nom2);
	pcl::PointCloud<pcl::Normal>::Ptr normals2 (new pcl::PointCloud<pcl::Normal>);
	ne2.setRadiusSearch(NORMR); // a
	ne2.compute(*normals2);

	pcl::FPFHEstimation<pcl::PointXYZRGB, pcl::Normal, pcl::FPFHSignature33> fpfh2;
	fpfh2.setInputCloud(target.makeShared());
	fpfh2.setInputNormals(normals2);
	pcl::search::KdTree<pcl::PointXYZRGB>::Ptr tree_fpfh2 (new pcl::search::KdTree<pcl::PointXYZRGB>());
	fpfh2.setSearchMethod(tree_fpfh2);
	pcl::PointCloud<pcl::FPFHSignature33>::Ptr fpfhs2 (new pcl::PointCloud<pcl::FPFHSignature33> ());
	fpfh2.setRadiusSearch(FPFHR); //a
	fpfh2.compute(*fpfhs2);
	printf("fpfh2 done\n");
	////////////////////////SAC
	printf("sac\n");
	pcl::SampleConsensusInitialAlignment<pcl::PointXYZRGB, pcl::PointXYZRGB, pcl::FPFHSignature33> sac;
	sac.setInputSource(source.makeShared());
	sac.setSourceFeatures(fpfhs);

	sac.setInputTarget(target.makeShared());
	sac.setTargetFeatures(fpfhs2);

	pcl::PointCloud<pcl::PointXYZRGB> final;
	sac.align(final);

	pcl::io::savePCDFile("tmp0_fpfh.pcd", final);

	boost::shared_ptr<pcl::visualization::PCLVisualizer> fpfh_viewer(new pcl::visualization::PCLVisualizer ("FPFH Viewer"));
	fpfh_viewer->initCameraParameters ();

	int v1 = 0;
	fpfh_viewer->createViewPort(0.0, 0.0, 0.5, 1.0, v1);
	fpfh_viewer->addText("before", 10, 10, "v1 text", v1);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_source(source.makeShared());
	fpfh_viewer->addPointCloud<pcl::PointXYZRGB> (source.makeShared(), rgb_source, "source", v1);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_target(target.makeShared());
	fpfh_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target1", v1);
	fpfh_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "source");
	fpfh_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target1");

	int v2 = 0;
	fpfh_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
	fpfh_viewer->addText("after", 10, 10, "v2 text", v2);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_final(final.makeShared());
	fpfh_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
	fpfh_viewer->addPointCloud<pcl::PointXYZRGB> (final.makeShared(), rgb_final, "final", v2);
	fpfh_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target2", v2);
	fpfh_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "final");
	fpfh_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target2");


	bool ShouldRun = true;

	while (ShouldRun) {  
		fpfh_viewer->spinOnce (100);
		boost::this_thread::sleep (boost::posix_time::microseconds (100000));
	}

}


// ICPASYpă|CgNEḧʒu킹s
// sourcẽ|CgNEhtarget̃|CgNEhɍ킹
// pathToFile  sourcẽ|CgNEhʒu킹̃t@C
void ICP(const pcl::PointCloud<pcl::PointXYZRGB> source, const pcl::PointCloud<pcl::PointXYZRGB> target, const std::string pathToFile){
	// ICP
	pcl::IterativeClosestPoint<pcl::PointXYZRGB, pcl::PointXYZRGB> icp;
	icp.setInputSource(source.makeShared());
	icp.setInputTarget(target.makeShared());

	// ʒu킹̃|CgNEh
	pcl::PointCloud<pcl::PointXYZRGB> aligned;

	// ICP̊ep[^̐ݒ\
	//icp.setMaxCorrespondenceDistance(0.015);
	//icp.setMaximumIterations(5);
	//icp.setRANSACIterations(5);


	// ICPASY̎s
	icp.align(aligned);

	//std::cout << "fitness: " << icp.getFitnessScore() << "\n";
	
	// p̃EBhE
	boost::shared_ptr<pcl::visualization::PCLVisualizer> icp_viewer(new pcl::visualization::PCLVisualizer ("ICP Viewer"));
	icp_viewer->initCameraParameters ();

	int v1 = 0;
	icp_viewer->createViewPort(0.0, 0.0, 0.5, 1.0, v1);
	icp_viewer->addText("before", 10, 10, "v1 text", v1);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_source(source.makeShared());
	icp_viewer->addPointCloud<pcl::PointXYZRGB> (source.makeShared(), rgb_source, "source", v1);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_target(target.makeShared());
	icp_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target1", v1);
	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "source");
	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target1");
	
	int v2 = 0;
	icp_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
	icp_viewer->addText("after", 10, 10, "v2 text", v2);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_final(aligned.makeShared());
	icp_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
	icp_viewer->addPointCloud<pcl::PointXYZRGB> (aligned.makeShared(), rgb_final, "final", v2);
	icp_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target2", v2);
	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "final");
	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target2");
	
	// ʒu킹̃|CgNEh̕ۑ
	pcl::io::savePCDFile(pathToFile, aligned);

	bool ShouldRun = true;
	while (ShouldRun) {  
		icp_viewer->spinOnce (100);
		boost::this_thread::sleep (boost::posix_time::microseconds (100000));
	}

	return;
}

//void ICPWithNormals(pcl::PointCloud<pcl::PointXYZRGB> source, pcl::PointCloud<pcl::PointXYZRGB> target){
//	
//	//icp
//
//	pcl::IterativeClosestPoint<pcl::PointXYZRGB, pcl::PointXYZRGB> icp;
//	icp.setInputSource(source.makeShared());
//	icp.setInputTarget(target.makeShared());
//
//	double fi = icp.getFitnessScore();
//	printf("fitness = %f\n",fi);
//	pcl::PointCloud<pcl::PointXYZRGB> final;
//	//icp.setMaxCorrespondenceDistance(0.015);
//	//icp.setMaximumIterations(5);
//	//icp.setRANSACIterations(5);
//	icp.align(final);
//
//
//	boost::shared_ptr<pcl::visualization::PCLVisualizer> icp_viewer(new pcl::visualization::PCLVisualizer ("ICP Viewer"));
//	icp_viewer->initCameraParameters ();
//
//	int v1 = 0;
//	icp_viewer->createViewPort(0.0, 0.0, 0.5, 1.0, v1);
//	icp_viewer->addText("before", 10, 10, "v1 text", v1);
//	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_source(source.makeShared());
//	icp_viewer->addPointCloud<pcl::PointXYZRGB> (source.makeShared(), rgb_source, "source", v1);
//	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_target(target.makeShared());
//	icp_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target1", v1);
//	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "source");
//	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target1");
//	
//	int v2 = 0;
//	icp_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
//	icp_viewer->addText("after", 10, 10, "v2 text", v2);
//	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_final(final.makeShared());
//	icp_viewer->createViewPort(0.5, 0.0, 1.0, 1.0, v2);
//	icp_viewer->addPointCloud<pcl::PointXYZRGB> (final.makeShared(), rgb_final, "final", v2);
//	icp_viewer->addPointCloud<pcl::PointXYZRGB> (target.makeShared(), rgb_target, "target2", v2);
//	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "final");
//	icp_viewer->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "target2");
//	
//	pcl::io::savePCDFile("tmp0_icp.pcd", final);
//
//	bool ShouldRun = true;
//
//	while (ShouldRun) {  
//		icp_viewer->spinOnce (100);
//		boost::this_thread::sleep (boost::posix_time::microseconds (100000));
//	}
//
//}