#include "BoF.h"

#define CODEBOOK



int main()
{
	int type = BoF::SIFT; // ʂ̎ SIFT or SURF

	BoF myBoF;
	// database_̌o
	myBoF.detectFeature("./database/", 0, 199, type);

#ifdef CODEBOOK
	// database̓ʂ̋Lq
	myBoF.computeDescriptors(type);

	cv::TermCriteria tc(CV_TERMCRIT_ITER, 10, 0.001); // ~
	// k-meansNX^OpăR[hubN̐ 500ނvisual word
	myBoF.createCodebook(500, tc, 1, cv::KMEANS_PP_CENTERS);

	myBoF.saveCodebook("./codebook_SIFT.xml");

#else
	myBoF.loadCodebook("./codebook_SIFT.xml");
	// databasẻ摜Lqq̐
	myBoF.createImageDescriptorsForImages(type);

	// query摜1ƂɎʂ
	for (int i = 0; i < 100; ++i) {
		std::stringstream str;
		str << "./query/image(" << i << ").jpg";
		cv::Mat img = cv::imread(str.str());
		
		cv::Mat similarImage;

		double dist = -1;
		int mostSimilarImageIndex = -1;
		// ގx̌vZ
		myBoF.computeMostSimilarImage(img, similarImage, mostSimilarImageIndex, dist, type);

		std::cout << "[" << i << "] : ";
		if (i < 50) {
			std::cout << "R  ";
		}
		else {
			std::cout << "X  ";
		}

		// ʌʂ̕\
		if (mostSimilarImageIndex < 100) {
			std::cout << "result : R (index : " << mostSimilarImageIndex << ", ގx : " << dist;
		}
		else {
			std::cout << "result : X (index : " << mostSimilarImageIndex << ", ގx : " << dist;
		}

		std::cout << ")\n";

		// ʂ摜1Ƃ̓RgAEg͂
		/*cv::imshow("img", img);
		cv::imshow("similarImage", similarImage);
		cv::waitKey();*/
	}
#endif

	std::cout << "\n";

	return 0;
}
	