#ifndef BOF_H
#define BOF_H

#include <opencv2/opencv.hpp>
#include <opencv2/nonfree/features2d.hpp>

class BoF {
public:
	BoF();
	~BoF();

	enum featureType {SIFT, SURF};

	// o
	void detectFeature(const std::string pathToFolder, const int start, const int end, const int featureType);
	// ʋLqq̌vZ
	void computeDescriptors(const int featureType);
	// R[hubN̐
	void createCodebook(const int size, const cv::TermCriteria tc, const int retries, const int flags);
	// 摜Lqq̐
	void createImageDescriptorsForImages(const int featureType);
	// ގxł摜߂
	void computeMostSimilarImage(const cv::Mat img, cv::Mat& similarImg, int& mostSimilarImageIndex, double& dist, const int featureType);


	// R[hubN̕ۑ
	void saveCodebook(const std::string pathToXML);
	// R[hubN̓ǂݍ
	void loadCodebook(const std::string pathToXML);


private:
	static const int DEFAULT_DESCRIPTOR_DIMENSION;
	static const int DEFAULT_GRID;

	int codebookSize;
	int descriptorDimension;
	int grid; // ObhTvOɂObh̕(pixel)
	std::vector<int> gridScale; // ObhTvOɂTṽXP[

	std::vector<cv::Mat> images;
	std::vector<cv::Mat> imageDescriptors;
	std::vector<std::vector<cv::KeyPoint>> keyPoints;
	std::vector<cv::Mat> descriptors; // grid sampling̐ *  Mat摜i[Ă

	cv::Mat codebook;

	cv::BOWKMeansTrainer *BoWTrainer;

	cv::BOWImgDescriptorExtractor *bowDE;
	cv::Ptr<cv::DescriptorMatcher> matcher;
	cv::Ptr<cv::DescriptorExtractor> extractor;

	// o(摜1)
	void detectFeatureOfImage(const cv::Mat img, std::vector<cv::KeyPoint>& imgKeyPoints, const int featureType);
	// 摜Lqq̐(摜1)
	void createImageDescriptor(const cv::Mat img, cv::Mat& imgDescriptor, const int featureType);
	// ގx̌vZ
	void computeSimilarityToImageDescriptors(const cv::Mat imgDescriptor, int& mostSimilarImageNum, double& dist);

};

#endif