#include "BoF.h"

const int BoF::DEFAULT_DESCRIPTOR_DIMENSION = 128;
const int BoF::DEFAULT_GRID = 20;


BoF::BoF()
{
	descriptorDimension = DEFAULT_DESCRIPTOR_DIMENSION;
	grid = DEFAULT_GRID;

	gridScale.push_back(30);
	gridScale.push_back(23);
	gridScale.push_back(18);
	gridScale.push_back(15);
	gridScale.push_back(12);
	gridScale.push_back(0);
}


BoF::~BoF() {}



// o
// pathToImage : 摜̂tH_ (tH_̒gimage(i).jpgƂȂĂKvL)
// start : Jn̔ԍ
// end : I̔ԍ
// featureType : ʂ̎
void BoF::detectFeature(const std::string pathToFolder, const int start, const int end, const int featureType)
{
	cv::Mat img;
	// e摜Ƃɓ_̌o
	for (int i = start; i <= end; ++i) {
		// 摜̓ǂݍ
		std::stringstream str;
		str << pathToFolder << "image(" << i << ").jpg";
		img = cv::imread(str.str());
		images.push_back(img);
		
		if(!img.empty()) {
			std::cout << "Load Image : " << str.str() << "\n";
		}
		// grid sampring
		if (featureType == SIFT || featureType == SURF) {
			std::vector<cv::KeyPoint> intoKeyPoints; // ݂̉摜ɂ_̏W

			int startX = (int)((img.cols & grid) + grid) / 2 - 1;
			int startY = (int)((img.rows & grid) + grid) / 2 - 1;
			
			cv::KeyPoint intoIntoKeyPoint;
						
			for (int s = 0; s < gridScale.size(); ++s) {
				for (int y = startY; y < img.rows; y += grid) {
					for (int x = startX; x < img.cols; x += grid) {			
						intoIntoKeyPoint.pt.x = (float)x;
						intoIntoKeyPoint.pt.y = (float)y;
						intoIntoKeyPoint.size = (float)gridScale[s];

						intoKeyPoints.push_back(intoIntoKeyPoint);
					}
				}
			}

			keyPoints.push_back(intoKeyPoints);

		}
	}

	return;
}


// ʋLqq̌vZ
// featureType : ʂ̎
void BoF::computeDescriptors(const int featureType)
{
	if (featureType == SIFT) {
		for (int i = 0; i < images.size(); ++i) {
			cv::Mat img = images[i];

			cv::SiftDescriptorExtractor extractor;
			descriptorDimension = extractor.descriptorSize();

			cv::Mat intoDescriptors;
			extractor.compute(img, keyPoints[i], intoDescriptors);
			descriptors.push_back(intoDescriptors);

			std::cout << "Compute Descriptors [" << i << "]\n";
		}
	}
	else if (featureType == SURF) {
		for (int i = 0; i < images.size(); ++i) {
			cv::Mat img = images[i];

			cv::SurfDescriptorExtractor extractor(500, 4, 2, true);
			descriptorDimension = extractor.descriptorSize();

			cv::Mat intoDescriptors;
			extractor.compute(img, keyPoints[i], intoDescriptors);
			descriptors.push_back(intoDescriptors);

			std::cout << "Compute Descriptors [" << i << "]\n";
		}
	}

	return;
}

// KMeansNX^OpR[hubN̐
// size : R[hubÑTCY
// tc : I
// retries : s
// flags : K-meansNX^OɂtO 
void BoF::createCodebook(const int size, const cv::TermCriteria tc, const int retries, const int flags)
{
	codebookSize = size;

	BoWTrainer = new cv::BOWKMeansTrainer(size, tc, retries, flags);

	for (int i = 0; i < descriptors.size(); ++i) {
		BoWTrainer->add(descriptors[i]);
	}

	std::cout << "start K-means clustering\n";
	codebook = BoWTrainer->cluster();
	std::cout << "end K-means clustering\n";

	delete BoWTrainer;

	return;
}


// 摜Lqq̐
// featureType : ʂ̎
void BoF::createImageDescriptorsForImages(const int featureType)
{
	if (featureType == SIFT) {
		extractor = new cv::SiftDescriptorExtractor;
		matcher = cv::DescriptorMatcher::create("FlannBased");

		bowDE = new cv::BOWImgDescriptorExtractor(extractor, matcher);
		bowDE->setVocabulary(codebook);

		for (int i = 0; i < images.size(); ++i) {
			cv::Mat intoImageDescriptors;
			bowDE->compute(images[i], keyPoints[i], intoImageDescriptors);
			imageDescriptors.push_back(intoImageDescriptors);

			std::cout << "create ImageDescriptor [" << i << "]\n";
		}
	}
	else if (featureType == SURF) {
		extractor = new cv::SurfDescriptorExtractor(500, 4, 2, true);
		matcher = cv::DescriptorMatcher::create("FlannBased");

		bowDE = new cv::BOWImgDescriptorExtractor(extractor, matcher);
		bowDE->setVocabulary(codebook);

		for (int i = 0; i < images.size(); ++i) {
			cv::Mat intoImageDescriptors;
			bowDE->compute(images[i], keyPoints[i], intoImageDescriptors);
			imageDescriptors.push_back(intoImageDescriptors);

			std::cout << "create ImageDescriptor [" << i << "]\n";
		}
	}

	return;
}


// R[hubN̕ۑ
// pathToXML : ۑt@C
void BoF::saveCodebook(const std::string pathToXML)
{
	cv::FileStorage cvfs(pathToXML, CV_STORAGE_WRITE);
	cv::write(cvfs, "codebook", codebook);

	return;
}


// R[hubN̓ǂݍ
// pathToXML : ǂݍރt@C
void BoF::loadCodebook(const std::string pathToXML)
{
	cv::FileStorage cvfs(pathToXML, CV_STORAGE_READ);
	cv::FileNode node(cvfs.fs, NULL);
	cv::read(node["codebook"], codebook);

	codebookSize = codebook.rows;

	std::cout << "codebook : " << codebook.size() << "\n";

	return;
}



// ގxł摜߂
// img : FΏۂ̉摜
// similarImg : ގxłwK摜
// mostSimilarImageIndex : ގxłwK摜̔ԍ
// dist : qXgŐ
// featureType : ʂ̎
void BoF::computeMostSimilarImage(const cv::Mat img, cv::Mat& similarImg, int& mostSimilarImageIndex, double& dist, const int featureType)
{
	cv::Mat imgDescriptor;
	createImageDescriptor(img, imgDescriptor, featureType);

	computeSimilarityToImageDescriptors(imgDescriptor, mostSimilarImageIndex, dist);

	similarImg = images[mostSimilarImageIndex].clone();

	return;
}


// o(摜1)
// img : ͉摜
// imgKeyPoints : oꂽ_̏W
// featureType : ʂ̎
void BoF::detectFeatureOfImage(const cv::Mat img, std::vector<cv::KeyPoint>& imgKeyPoints, const int featureType)
{
	if (featureType == SIFT || featureType == SURF) {
		//Grid Sampling
		int startX = (int)((img.cols % grid) + grid ) / 2 - 1;
		int startY = (int)((img.rows % grid) + grid ) / 2 - 1;

		cv::KeyPoint into_keyPoints;
		for (int s = 0; s < gridScale.size(); s++) {
			for (int y = startY; y < img.rows; y += grid) {
				for (int x = startX; x < img.cols; x += grid) {
					into_keyPoints.pt.x = (float)x;
					into_keyPoints.pt.y = (float)y;
					into_keyPoints.size = (float)gridScale[s];

					imgKeyPoints.push_back(into_keyPoints);
				}
			}
		}
	}

	return;
}


// 摜Lqq̐(摜1)
// img : ͉摜
// imgDescriptor : ꂽ摜Lqq
// featureType : _̎
void BoF::createImageDescriptor(const cv::Mat img, cv::Mat& imgDescriptor, const int featureType)
{
	if (featureType == SIFT) {
		extractor = new cv::SiftDescriptorExtractor;
		matcher = cv::DescriptorMatcher::create("FlannBased");

		bowDE = new cv::BOWImgDescriptorExtractor(extractor, matcher);
		bowDE->setVocabulary(codebook);

		std::vector<cv::KeyPoint> imgKeyPoints;
		detectFeatureOfImage(img, imgKeyPoints, featureType);
		bowDE->compute(img, imgKeyPoints, imgDescriptor);
	}
	else if (featureType == SURF) {
		extractor = new cv::SurfDescriptorExtractor(500, 4, 2, true);
		matcher = cv::DescriptorMatcher::create("FlannBased");

		bowDE = new cv::BOWImgDescriptorExtractor(extractor, matcher);
		bowDE->setVocabulary(codebook);

		std::vector<cv::KeyPoint> imgKeyPoints;
		detectFeatureOfImage(img, imgKeyPoints, featureType);
		bowDE->compute(img, imgKeyPoints, imgDescriptor);
	}

	return;
}



// ގx̌vZ
// imgDescriptorimgaeDescriptorsƔrCƂގx摜̔ԍƁCqXgŐԂ
// imgDescriptor : ʂ摜̋Lqq
// mostSimilarImageIndex : łގxwK摜̔ԍ
// dist : qXgŐ
void BoF::computeSimilarityToImageDescriptors(const cv::Mat imgDescriptor, int& mostSimilarImageIndex, double& dist)
{
	double dMax = -2.0;
	int index = -1;
	cv::Mat tmpDescriptor = imgDescriptor.clone();

	for (int i = 0; i < imageDescriptors.size(); ++i) {
		imageDescriptors[i].convertTo(imageDescriptors[i], CV_32FC1);
		tmpDescriptor.convertTo(tmpDescriptor, CV_32FC1);

		double d = cv::compareHist(imageDescriptors[i], tmpDescriptor, CV_COMP_CORREL);

		if (d > dMax) {
			dMax = d;
			index = i;
		}
	}

	dist = dMax;
	mostSimilarImageIndex = index;

	return;
}

