#ifndef MY_KINECT
#define MY_KINECT

#include <Windows.h>
#include <NuiApi.h> // windows.ȟinclude



#include <opencv2/opencv.hpp>

#include <pcl/point_types.h> 
#include <pcl/visualization/cloud_viewer.h> // opencv̌include

#include <pcl/io/pcd_io.h>


#include <iostream>
#include <sstream>

#define ERROR_CHECK(ret) \
	if (ret != S_OK) { \
	std::stringstream ss; \
	ss << "failed " #ret " " << std::hex << ret << "\n"; \
	throw std::runtime_error(ss.str().c_str()); \
	}


const NUI_IMAGE_RESOLUTION COLOR_RESOLUTION = NUI_IMAGE_RESOLUTION_640x480;
const NUI_IMAGE_RESOLUTION DEPTH_RESOLUTION = NUI_IMAGE_RESOLUTION_640x480;

class MyKinect
{
public:
	MyKinect();
	~MyKinect();

	void showColorAndDepthImg();
	void showPointCloud();
	
	cv::Mat getColorImage();
	cv::Mat getDepthImage();
	cv::Mat getDepthImageShowed();

	void saveData();		//ef[^̕ۑ

private:
	INuiSensor* kinect;
	HANDLE imageStreamHandle;
	HANDLE depthStreamHandle;
	HANDLE streamEvent;

	DWORD width, height;

	bool isInitialized;

	static const float MAX_DEPTH; // Kinect擾łődepth

	void initInstance();
	static void CALLBACK StatusChanged(HRESULT hrStatus,
		const OLECHAR* instanceName,
		const OLECHAR* uniqueDeviceName,
		void* pUserData);
	void CALLBACK StatusChanged(HRESULT hrStatus,
		const OLECHAR* instanceName,
		const OLECHAR* uniqueDeviceName);
	void close();

	cv::Mat rgbImage;			// J[摜

	cv::Mat rawDepthData;		// J̉摜Wn̋f[^(16bit, 3bit̓vC[ID)
	cv::Mat rawDepthImage;		// J̉摜Wn̋摜	߂قǖ邢F

	cv::Mat depthData_Mat;		// J[摜Wn̋f[^(16bit, rawDepthData̒l3bitVtg)	͐GȂłł
	cv::Mat depthImage;			// J[摜Wn̋摜	߂قǖ邢F
	cv::Mat depthImage_double;

	pcl::PointCloud<pcl::PointXYZRGB>::Ptr cloud;	//PointCloud
	pcl::visualization::CloudViewer *viewer;		//PointCloud̃r[[

	//t[s
	void setRgbImage();			//J[摜̃Zbg
	void setDepthImage();		//f[^C摜̃ZbgCPointCloud̃Zbg
	void setPointCloud();		//(PointCloud̃Zbg)

	void flipImgs();			//Mat̍E]

};


#endif // ! MY_KINECT