#include "MyKinect.h"

const float MyKinect::MAX_DEPTH = 4096.0;


MyKinect::MyKinect() {
	::NuiSetDeviceStatusCallback(StatusChanged, this);

	// ڑĂKinect̐擾
	int count = 0;
	ERROR_CHECK(::NuiGetSensorCount(&count));

	if (count != 0) {
		// ŏKinect̃CX^X𐶐
		ERROR_CHECK(::NuiCreateSensorByIndex(0, &kinect));

		// Kinect̏Ԃ擾
		HRESULT status = kinect->NuiStatus();
		if (status != S_OK) {
			throw std::runtime_error("Kinectp\ł͂܂");
		}
	}

	if (kinect != 0) {
		initInstance();
	}
}


MyKinect::~MyKinect()
{
	// I
	if (kinect != 0) {
		kinect->NuiShutdown();
		kinect->Release();
	}
}



void MyKinect::showColorAndDepthImg()
{
	// C[v
	while (1) {
		// KinectڑC̏ꍇ́CX[vďȂ
		if ((kinect == 0) || !isInitialized) {
			::Sleep(1000);
			continue;
		}

		try {
			// f[^̍XV҂
			DWORD ret = ::WaitForSingleObject(streamEvent, INFINITE);
			if ((ret == WAIT_FAILED) || (streamEvent == 0)) {
				continue;
			}
			::ResetEvent(streamEvent);

			// J[摜C摜̎擾
			setRgbImage();
			setDepthImage();

			// 摜\
			cv::imshow("ColorImage", rgbImage);
			cv::imshow("rawDepthImage", rawDepthImage);
			cv::imshow("DepthImage", depthImage);

			// Î߂̃L[̓`FbN\̂߂̃EFCg
			int key = cv::waitKey(10);
			if (key == 'q') {
				break;
			}
		}
		catch (std::exception &ex) {
			std::cout << ex.what() << "\n";
		}
	}

	return;
}


void MyKinect::showPointCloud()
{

	// C[v
	while (1) {
		// KinectڑC̏ꍇ́CX[vďȂ
		if ((kinect == 0) || !isInitialized) {
			::Sleep(1000);
			continue;
		}

		try {
			// f[^̍XV҂
			DWORD ret = ::WaitForSingleObject(streamEvent, INFINITE);
			if ((ret == WAIT_FAILED) || (streamEvent == 0)) {
				continue;
			}
			::ResetEvent(streamEvent);

			// J[摜E摜EPointCloud̃Zbg
			setRgbImage();
			setDepthImage();
			//setPointCloud();

			// 摜̍E]
			flipImgs();

			// J[摜E摜\
			cv::imshow("ColorImage", rgbImage);
			cv::imshow("RawDepthImage", rawDepthImage);
			cv::imshow("DepthImage", depthImage);

			// PointCloud̕\
			viewer->showCloud(cloud);


			int key = cv::waitKey(10);
			// Î߂̃L[̓`FbN\̂߂̃EFCg
			if (key == 'q')
				break;
			else if(key == 's') {	//ef[^ۑ
				saveData();
			}

		}
		catch (std::exception &ex) {
			std::cout << ex.what() << "\n";
		}
	}

	cout << "frm: " << frm << endl;

	return;
}



cv::Mat MyKinect::getColorImage()
{


	return rgbImage;
}


cv::Mat MyKinect::getDepthImage()
{
	return depthImage;
}


cv::Mat MyKinect::getDepthImageShowed()
{
	return depthImage;
}

void MyKinect::saveData()
{
	//J[摜E摜Ȃǂo
	//Matxml`ŏo
	//PointCloudo
	//ł΃t@CŒ͔(㏑h~̂)
	//ۑ̓xɃt@CR}hvvgœ͂Ct[Ƃăt@CɑgݍށCetc...
	//
	//
	//
	//

	return;
}


void MyKinect::initInstance()
{
	// Kinect̐ݒ
	ERROR_CHECK(kinect->NuiInitialize(NUI_INITIALIZE_FLAG_USES_COLOR |
		NUI_INITIALIZE_FLAG_USES_DEPTH));

	// RGBJ
	ERROR_CHECK(kinect->NuiImageStreamOpen(NUI_IMAGE_TYPE_COLOR, COLOR_RESOLUTION, 0, 2, 0, &imageStreamHandle));

	// DephtJ
	ERROR_CHECK(kinect->NuiImageStreamOpen(NUI_IMAGE_TYPE_DEPTH, DEPTH_RESOLUTION, 0, 2, 0, &depthStreamHandle));

	// t[XVCxg̃nh쐬
	streamEvent = ::CreateEvent(0, TRUE, FALSE, 0);
	ERROR_CHECK(kinect->NuiSetFrameEndEvent(streamEvent, 0));

	//PointCloudr[̏
	viewer = new pcl::visualization::CloudViewer("Kinect Point Cloud");

	// w肵𑜓x̉ʃTCY擾
	::NuiImageResolutionToSize(COLOR_RESOLUTION, width, height);

	isInitialized = true;

	return;
}

// Kincet̏ԂςƂɌĂ΂R[obN֐(NX֐)
void CALLBACK MyKinect::StatusChanged(HRESULT hrStatus,
									  const OLECHAR* instanceName,
									  const OLECHAR* uniqueDeviceName,
									  void* pUserData)
{
	((MyKinect *)pUserData)->StatusChanged(hrStatus, instanceName, uniqueDeviceName);
}


// Kincet̏ԂςƂɌĂ΂R[obN֐(o֐)
void CALLBACK MyKinect::StatusChanged(HRESULT hrStatus,
									  const OLECHAR* instanceName,
									  const OLECHAR* uniqueDeviceName)
{
	// Kinectڑꂽ
	if (hrStatus == S_OK) {
		// ڑꂽKinect̃CX^X𐶐
		ERROR_CHECK(::NuiCreateSensorById(instanceName, &kinect));

		initInstance();
	}
	// Kinectꂽ
	else if (hrStatus == E_NUI_NOTCONNECTED) {
		close();
	}
}


void MyKinect::close()
{
	// I
	if (kinect != 0) {
		kinect->NuiShutdown();
		kinect->Release();
		kinect = 0;
		isInitialized = false;

		// Cxgnh
		if (streamEvent != 0) {
			::SetEvent(streamEvent);
			::CloseHandle(streamEvent);
			streamEvent = 0;
		}
	}

	return;
}


void MyKinect::setRgbImage()
{
	try {
		// RGBJ̃t[f[^擾
		NUI_IMAGE_FRAME imageFrame = {0};
		ERROR_CHECK(kinect->NuiImageStreamGetNextFrame(imageStreamHandle, 0, &imageFrame));

		// 摜f[^擾
		NUI_LOCKED_RECT colorData;
		imageFrame.pFrameTexture->LockRect(0, &colorData, 0, 0);

		// 摜f[^Rs[
		rgbImage = cv::Mat(height, width, CV_8UC4, colorData.pBits);
		// CV_8UC3ɕς
		cv::cvtColor(rgbImage, rgbImage, CV_RGBA2RGB);
		// \摜𔽓]
		//cv::flip(rgbImage, rgbImage, 1);

		// t[f[^
		ERROR_CHECK(kinect->NuiImageStreamReleaseFrame(imageStreamHandle, &imageFrame));

	}
	catch (std::exception &ex) {
		std::cout << ex.what() << std::endl;
	}

	return;
}


void MyKinect::setDepthImage()
{
	try {

		// DepthJ̃t[f[^擾
		NUI_IMAGE_FRAME depthFrame = {0};
		ERROR_CHECK(kinect->NuiImageStreamGetNextFrame(depthStreamHandle, 0, &depthFrame));

		// f[^擾
		NUI_LOCKED_RECT depthData = {0};
		depthFrame.pFrameTexture->LockRect(0, &depthData, 0, 0);

		USHORT* depth = (USHORT*)depthData.pBits;

		// 摜(摜WnƃJ[摜Wnꂼ)
		rawDepthData = cv::Mat(height, width, CV_16UC1, depthData.pBits);
		rawDepthImage = cv::Mat(height, width, CV_8U, cv::Scalar(0));

		depthData_Mat = cv::Mat(height, width, CV_16UC1, cv::Scalar(0));
		depthImage = cv::Mat(height, width, CV_8U, cv::Scalar(0));

		// PointCloud
		pcl::PointCloud<pcl::PointXYZRGB>::Ptr points(new pcl::PointCloud<pcl::PointXYZRGB>);
		// PointCloud̃TCYw
		points->width = width;
		points->height = height;

		for(int row = 0; row < rawDepthData.rows; row++) {
			for(int col = 0; col < rawDepthData.cols; col++) {
				LONG colorX;																	//ΉJ[摜xW
				LONG colorY;																	//ΉJ[摜yW
				USHORT distance = ::NuiDepthPixelToDepth(rawDepthData.at<USHORT>(row, col));	//(Pmm)


				// JWn̋摜ۑ--------------------------------------------------------
				// ɉĖxlݒ(߂قǖ邢orÂ)
				//
				//
				//
				//

				// 擾͈͊Oɂ	߂ΔCӂ͈̔͂̋摜ɂȂ
				if(((float)distance < 500.0) || (MAX_DEPTH < (float)distance))
					rawDepthImage.at<UCHAR>(row, col) = 0;


				// J[JWn̋摜ۑ------------------------------------------------------
				// DepthJ̍WRGBJ̍Wɕϊ
				kinect->NuiImageGetColorPixelCoordinatesFromDepthPixelAtResolution(COLOR_RESOLUTION,
					DEPTH_RESOLUTION, 0, col, row, rawDepthData.at<USHORT>(row, col), &colorX, &colorY);

				// ϊ̍WJ[摜W(640x480)Ɋ܂܂Ă邩`FbN
				//
				//
				//
				//

				
				// 擾͈͓ɐFÂ
				//
				//
				//
				//


				// PointCloudɕۑ------------------------------------------------------------------------
				// 3Wnɕϊ(Pm)
				//
				//
				//
				//

				//̏߂ΔCӂ͈̔͂̋ł̓_QɂȂ
				if(500.0 < (float)distance && (float)distance < MAX_DEPTH) {
					pcl::PointXYZRGB point;
					// 3_̈ʒuƐF
					//
					//
					//
					//

					// pointsɊi[
					points->push_back(point);
				}

			}
		}

		cloud = points;

		// t[f[^
		ERROR_CHECK(kinect->NuiImageStreamReleaseFrame(depthStreamHandle, &depthFrame));
	}
	catch (std::exception &ex) {
		std::cout << ex.what() << std::endl;
	}

	return;
}


void MyKinect::setPointCloud()
{
	try {

		// PointCloud
		pcl::PointCloud<pcl::PointXYZRGB>::Ptr points(new pcl::PointCloud<pcl::PointXYZRGB>);
		// PointCloud̃TCYw
		points->width = width;
		points->height = height;

		for(int row = 0; row < rawDepthData.rows; row++) {
			for(int col = 0; col < rawDepthData.cols; col++) {
				LONG colorX;																	//ΉJ[摜xW
				LONG colorY;																	//ΉJ[摜yW
				USHORT distance = ::NuiDepthPixelToDepth(rawDepthData.at<USHORT>(row, col));	//(Pmm)

				// DepthJ̍WRGBJ̍Wɕϊ
				kinect->NuiImageGetColorPixelCoordinatesFromDepthPixelAtResolution(COLOR_RESOLUTION,
					DEPTH_RESOLUTION, 0, col, row, rawDepthData.at<USHORT>(row, col), &colorX, &colorY);

				// PointCloudɕۑ------------------------------------------------------------------------
				//@3Wnɕϊ(Pm)
				//
				//
				//
				//

				//̏߂ΔCӂ͈̔͂̋ł̓_QɂȂ
				if(500.0 < (float)distance && (float)distance < MAX_DEPTH) {
					pcl::PointXYZRGB point;
					// 3_̈ʒuƐF
					//
					//
					//
					//

					//pointsɊi[
					points->push_back(point);
				}

			}
		}

		cloud = points;

	}
	catch (std::exception &ex) {
		std::cout << ex.what() << std::endl;
	}

	return;
}

void MyKinect::flipImgs()
{
	cv::flip(rgbImage, rgbImage, 1);

	cv::flip(rawDepthData, rawDepthData, 1);
	cv::flip(rawDepthImage, rawDepthImage, 1);

	cv::flip(depthData_Mat, depthData_Mat, 1);
	cv::flip(depthImage, depthImage, 1);

	return;
}