#if !defined( MT_SERIAL_H )
#define MT_SERIAL_H
//d`h~
//--------------------------------------------
//     Serial.h Version 0.60 for win32
//--------------------------------------------

#include <windows.h>

class COMPORT
{
	HANDLE			hCom;		//Handle of This Communication Port.
	COMMPROP		Properties;	//Performance Properties of This Communication Port
	COMMTIMEOUTS	ctmo;		//Setting of Timeout Duration
	DCB				dcb;		//Setting of Serial Connection

public:
	COMPORT( char *PORT );
	COMPORT( char *PORT, DWORD Speed );
	BOOL check( void )
	{
		if( hCom == INVALID_HANDLE_VALUE ) return FALSE;
		return TRUE;
	}
	void loadDefalutState();
	~COMPORT() { CloseHandle( hCom ); }
	void setBaudRate( DWORD setValue )
	{
		dcb.BaudRate = setValue;
		setState();
	}
	void setStopBits( BYTE setValue )
	{
		dcb.StopBits = setValue;
		setState();
	}
	void setParity( BYTE setValue )
	{
		dcb.Parity = setValue;
		dcb.Parity == 0 ? dcb.fParity = FALSE: dcb.fParity = TRUE;
		setState();
	}
	void setReadTimeOut( int Interval, int Multiplier, int Constant )
	{
		ctmo.ReadIntervalTimeout = Interval;
		ctmo.ReadTotalTimeoutMultiplier = Multiplier;
		ctmo.ReadTotalTimeoutConstant = Constant;
		setState();
	}
	void setWriteTimeOut( int Multiplier, int Constant )
	{
		ctmo.WriteTotalTimeoutMultiplier = Multiplier;
		ctmo.WriteTotalTimeoutConstant = Constant;
		setState();
	}
	void setState()
	{
		SetCommState(hCom, &dcb);
		SetCommTimeouts(hCom, &ctmo);
	}
	void  purgeNow( void )	{ PurgeComm( hCom, PURGE_TXABORT | PURGE_RXABORT );	}
	void  purgeBuff( void )	{ PurgeComm( hCom, PURGE_TXCLEAR | PURGE_RXCLEAR );	}
	DWORD receive( BYTE *lpBuff, DWORD BuffLength )
	{
		DWORD	ret;
		ReadFile( hCom, lpBuff, BuffLength, &ret, NULL ); //ǂݍ
		return ret;
	}
	DWORD transmit( BYTE *lpBuff, DWORD BuffLength )
	{
		DWORD	ret;
		WriteFile( hCom, lpBuff, BuffLength, &ret, NULL ); //o
		return ret;
	}
};

COMPORT::COMPORT( char *PORT )
{
	hCom	= CreateFile(PORT, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, NULL, NULL);
	loadDefalutState();
	setState();
}

COMPORT::COMPORT( char *PORT, DWORD Speed )
{
	hCom	= CreateFile(PORT, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, NULL, NULL);
	loadDefalutState();
	setBaudRate( Speed );
	setState();
}

void COMPORT::loadDefalutState()
{
	GetCommProperties(hCom, &Properties);
	GetCommState(hCom, &dcb);

	//Default Value of This Class.
	dcb.DCBlength			= sizeof(DCB);
	dcb.BaudRate			= 9600;
	dcb.fBinary				= TRUE;		//In the NT Kernel, allways keep true;
	dcb.fParity				= FALSE;
	dcb.fOutxCtsFlow		= FALSE;
	dcb.fOutxDsrFlow		= FALSE;
	dcb.fDtrControl			= DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity		= FALSE;

	dcb.fTXContinueOnXoff	= FALSE;	/* XOFFMp	*/
	dcb.fOutX				= FALSE;	/* XON/XOFFo̓t[	*/
	dcb.fInX				= FALSE;	/* XON/XOFF̓t[	*/
	dcb.fErrorChar			= FALSE;	/* G[ɂuL	*/
	dcb.fNull				= FALSE;	/* k XgbsOL	*/
	dcb.fRtsControl			= RTS_CONTROL_ENABLE;	// RTSt[
	dcb.fAbortOnError		= FALSE;	/* G[ɓǂݎ܂͏݂𒆎~	*/
//		dcb.fDummy2				;			/* \ς	*/
//		dcb.wReserved			;			/* o[Wł͎gȂ	*/
//		dcb.XonLim				= ;			/* MɂXONXbVh	*/
//		dcb.XoffLim				= ;			/* MɂXOFFXbVh	*/

	dcb.ByteSize			= 8;
	dcb.Parity				= 0;
	dcb.StopBits			= ONESTOPBIT;	//This Memory Take ONESTOPBIT or ONE5STOPBITS or TWOSTOPBITS

	dcb.XonChar				= 0;			/* MюMɑ΂XON	*/
	dcb.XoffChar			= (char)0xff;	/* MюMɑ΂XON	*/
	dcb.ErrorChar			= 0;			/* G[u	*/
	dcb.EofChar				= 0;			/* ͕̏I	*/
	dcb.EvtChar				= 0;			/* 󂯎Cxg	*/

	ctmo.ReadIntervalTimeout = 10;
	ctmo.ReadTotalTimeoutMultiplier = 10;
	ctmo.ReadTotalTimeoutConstant = 100;//50-1
	ctmo.WriteTotalTimeoutMultiplier = 10;
	ctmo.WriteTotalTimeoutConstant = 100;
}

#endif // !defined( MT_SERIAL_H )