//쐬 OcƁ@ 3/12

#include "main.h"
#include "keyboard.h"
#include "callBack.h"

void glInt(int ,char*);
void idle();
void display();
void drawJointPoint(xn::DepthGenerator&, xn::SkeletonCapability&, XnSkeletonJoint, std::string, XnUserID, Mat_<Vec3b>);

void glInit (int argc, char *argv[]){
 glutInit(&argc, argv);
 glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGB);
 glutInitWindowSize(640, 480);
 glutCreateWindow("sample");
 glDisable(GL_DEPTH_TEST);
 glEnable(GL_TEXTURE_2D);

 glEnableClientState(GL_VERTEX_ARRAY);
 glDisableClientState(GL_COLOR_ARRAY);

 CvMat* Amatrix = cvCreateMat(3,3,CV_32FC1);

 cvmSet(Amatrix, 0, 0, 526.37);
 cvmSet(Amatrix, 0, 1, 0.0);
 cvmSet(Amatrix, 0, 2, 313.68);
 cvmSet(Amatrix, 1, 0, 0.0);
 cvmSet(Amatrix, 1, 1, 526.37);
 cvmSet(Amatrix, 1, 2, 259.01);
 cvmSet(Amatrix, 2, 0, 0.0);
 cvmSet(Amatrix, 2, 1, 0.0);
 cvmSet(Amatrix, 2, 2, 1.0);


 glClearColor(0.0, 0.0, 0.0, 1.0);
 int camW = 640;
 int camH = 480;
 int x0 = (int)(cvmGet(Amatrix, 0, 2) - camW / 2);
 int y0 = (int)(camH / 2 - cvmGet(Amatrix, 1, 2));
 glViewport(x0, y0, camW, camH);
 double fovy = 2.0 * atan(camH / (2.0 * cvmGet(Amatrix, 1, 1))) * 180.0 / CV_PI;
 double aspect = (camW * cvmGet(Amatrix, 1, 1)) / (camH * cvmGet(Amatrix, 0, 0));
 glMatrixMode(GL_PROJECTION);
 glLoadIdentity();
 gluPerspective(fovy, aspect, 10, 10000);
 glMatrixMode(GL_MODELVIEW);
}


void idle(){
    glutPostRedisplay();
}


class Kinect {
protected:
	int WIDTH;
	int HEIGHT;
	xn::ImageGenerator image; // C[WReLXg  
	xn::DepthGenerator depth; // [xReLXg
	xn::UserGenerator  user;  // [UReLXg
	xn::ImageMetaData imageMD;  //J[摜
    xn::DepthMetaData depthMD;  //fvX摜
	xn::SceneMetaData sceneMD;  //[Ü
	
	xn::SkeletonCapability skeleton; // gbLOXPg
	
	xn::Context context;

public:
	
	//RXgN^@ɏ
	Kinect(): skeleton(skeleton){
		//OpenNÎ̏
		XnCallbackHandle userCallbacks, calibrationCallbacks, poseCallbacks;
		XnChar pose[20] = "";

		context.Init();
		image.Create(context);
		depth.Create(context);

		 // [U[̍쐬
        user.Create(context);
		
		//XPggbLO̐
		skeleton = user.GetSkeletonCap();
		skeleton.GetCalibrationPose(pose);

		//o邽тɌĂ΂R[obN֐
		xn::PoseDetectionCapability Pose = user.GetPoseDetectionCap();
		Pose.RegisterToPoseCallbacks(&::PoseDetected, &::PoseLost, &user, poseCallbacks);
		user.RegisterUserCallbacks(&::UserDetected, &::UserLost, 0, userCallbacks);
		skeleton.RegisterCalibrationCallbacks(&::CalibrationStart, &::CalibrationEnd, &user, calibrationCallbacks); 
		//擾镔ʁD͑SD
		skeleton.SetSkeletonProfile(XN_SKEL_PROFILE_ALL);


		//WFX`[o̊Jn
		context.StartGeneratingAll();
		WIDTH = 480;
		HEIGHT = 640;
	}
	~Kinect(){
		context.Shutdown();
	}

	void run(){
		glutDisplayFunc(display);
		glutIdleFunc(idle);
		glutMainLoop();
	}
	//f[^̍XV
	void update(){
		context.WaitAndUpdateAll();
	}
	//RGB摜̎擾
	Mat getRGBImage(){
		Mat_<Vec3b> rgb_image(480, 640);
		image.GetMetaData(imageMD);
		memcpy(rgb_image.data,imageMD.Data(),rgb_image.step * rgb_image.rows);
		cvtColor(rgb_image,rgb_image,CV_RGB2BGR); 
		return rgb_image;
	}
	//fvX摜̎擾
	Mat getDepthImage(){
		Mat_<Vec3b> depth_image(480, 640);
		depth.GetAlternativeViewPointCap().SetViewPoint(image);					//Y␳
		depth.GetMetaData(depthMD);
		for(int i = 0; i < depth_image.rows;i++){
			 for (int j = 0; j < depth_image.cols; j++){
				 depth_image[i][j].val[0] = depthMD(j,i) * 255.0 / 4096.0;
				 depth_image[i][j].val[1] = 0;
				 depth_image[i][j].val[2] = depthMD(j,i) * 255.0 / 4096.0;
			 }
		}
		return depth_image;
	}
	//ľo
	Mat getUserTracking(Mat_<Vec3b> Image){
		
		user.GetUserPixels(0, sceneMD);

		for ( int y = 0; y < WIDTH; y++){
			for ( int x = 0; x < HEIGHT; x++){
				XnLabel label = sceneMD(x,y);
				if(label > 0){
					Image[y][x].val[0] = label%2 == 0 ? 0 : 255;
					Image[y][x].val[1] = label%2 == 0 ? 255 : 0;
					Image[y][x].val[2] = label%3 == 0 ? 255 : 0;
				}
			}
		}
		return Image;
	}
	
	
	
	//l̕ʂ̌o
	Mat getSkeletonTracking(Mat_<Vec3b> Image){
		
		user.GetUserPixels(0, sceneMD);

		for ( int y = 0; y < WIDTH; y++){
			for ( int x = 0; x < HEIGHT; x++){
				XnLabel label = sceneMD(x,y);
				if(label > 0){
					Image[y][x].val[0] = label%2 == 0 ? 0 : 255;
					Image[y][x].val[1] = label%2 == 0 ? 255 : 0;
					Image[y][x].val[2] = label%3 == 0 ? 255 : 0;
				}
			}
		}

		XnUserID allUsers[20];
		XnUInt16 nUsers = 20;
		user.GetUsers(allUsers, nUsers);

		for (int i = 0; i < nUsers; i++) {

				// Lu[VɐĂ邩ǂ
				if (skeleton.IsTracking(allUsers[i])) {

					XnUserID u = allUsers[i];
					drawJointPoint(depth, skeleton, XN_SKEL_HEAD, "HEAD", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_NECK, "NECK", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_TORSO, "TORSO", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_LEFT_ELBOW, "LEFT ELBOW", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_ELBOW, "RIGHT ELBOW", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_LEFT_HIP, "LEFT HIP", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_HIP, "RIGHT HIP", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_LEFT_KNEE, "LEFT KNEE", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_KNEE, "RIGHT KNEE", u, Image);
					drawJointPoint(depth, skeleton, XN_SKEL_LEFT_HAND, "LEFT HAND", u, Image);
					drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_HAND, "RIGHT HAND", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_LEFT_SHOULDER, "SHOULDER", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_SHOULDER, "SHOULDER", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_LEFT_FOOT, "LEFT FOOT", u, Image);
					//drawJointPoint(depth, skeleton, XN_SKEL_RIGHT_FOOT, "RIGHT FOOT", u, Image);

					// ŏ̈l甲
					break;
				}
			}


		return Image;
	}

};

//O[oϐ---------------------

int pushKey;
Mat_<Vec3b> rgbImage(480, 640);
Mat_<Vec3b> depthImage(480, 640);
Mat_<Vec3b> userTrack(480, 640);
Mat_<Vec3b> skeletonTrack(480, 640);

Kinect kinect;

//-----------------------------------

int main(int argc, char *argv[]){
	glInit(argc,argv);
	kinect.run();
	return 0;
}

//摜ɃgbNĂ镔ʂ`
void drawJointPoint(xn::DepthGenerator& depth, xn::SkeletonCapability& capability, XnSkeletonJoint joint, std::string name, XnUserID user, Mat_<Vec3b> Image) {
	XnSkeletonJointPosition pos;
	// WCgW̎擾
	capability.GetSkeletonJointPosition(user, joint, pos);
	XnPoint3D pReal[1] = {pos.position};
	XnPoint3D pProjective[1];

	//cout << name << " : (" << (double)pReal[0].X << ", " << (double)pReal[0].Y << ", " << (double)pReal[0].Z << ")" << endl;

	// EWn\WnɕϊW擾
	depth.ConvertRealWorldToProjective(1, pReal, pProjective);

	// WCg̈ʒuɉ~`
	cv::circle(Image, cv::Point(pProjective[0].X, pProjective[0].Y), 6, CV_RGB(255,255,255), 2, CV_AA, 0);
	// WCg̖O`
	cv::putText(Image, name.c_str(), cv::Point(pProjective[0].X+10, pProjective[0].Y+10), cv::FONT_HERSHEY_SIMPLEX,1.0, CV_RGB(255, 230, 50),2,CV_AA);
}


//`XVĂ镔@ɂɏĂƂI
void display(){

	kinect.update();

	//RGB摜擾
	rgbImage = kinect.getRGBImage();
	//fvX摜擾
	depthImage = kinect.getDepthImage();
	//[U擾
	userTrack = kinect.getUserTracking(rgbImage);
	//Lu[Vsl̑̂̕ʂ̃gbLO
	skeletonTrack = kinect.getSkeletonTracking(rgbImage);

	imshow("rgbImage",rgbImage);
	imshow("depthImage",depthImage);
	imshow("userTracking",userTrack);
	imshow("skeletonTracking",skeletonTrack);
	


	//L[암
	pushKey = keyboard();
	if(pushKey==1){
		exit(0);
	}
}