#ifndef MY_CALLBACK
#define MY_CALLBACK

#include <XnCppWrapper.h>
#include <iostream>

using namespace std;

// [Uo
void XN_CALLBACK_TYPE UserDetected( xn::UserGenerator& generator, XnUserID nId, void* pCookie )
{
    std::cout << "[Uo:" << nId << " " << generator.GetNumberOfUsers() << "l" << std::endl;

    generator.GetSkeletonCap().RequestCalibration(nId, TRUE);
}

// [U
void XN_CALLBACK_TYPE UserLost( xn::UserGenerator& generator, XnUserID nId, void* pCookie )
{
	
	cout << "[UID : " << nId  << "܂" << endl;
}

//|[Yo
void XN_CALLBACK_TYPE PoseDetected(xn::PoseDetectionCapability& capability,const XnChar* strPose, XnUserID nId, void* pCookie)
{
	cout << "|[Yo : " << strPose <<"[U : " << nId << endl;

	xn::UserGenerator* user = (xn::UserGenerator*)pCookie;
	user->GetPoseDetectionCap().StopPoseDetection(nId);
	user->GetSkeletonCap().RequestCalibration(nId,TRUE);
}

//|[Y
void XN_CALLBACK_TYPE PoseLost(xn::PoseDetectionCapability& capability,const XnChar* strPose, XnUserID nId, void* pCookie)
{
	cout << "|[Y : " << strPose <<"[U : " << nId << endl;
}

// Lu[V̊Jn
void XN_CALLBACK_TYPE CalibrationStart(xn::SkeletonCapability& capability, XnUserID nId, void* pCookie)
{
	cout << "Lu[VJnD[U : " << nId << endl;
}

// Lu[V̏I
void XN_CALLBACK_TYPE CalibrationEnd(xn::SkeletonCapability& capability, XnUserID nId, XnBool bSuccess, void* pCookie)
{
    // Lu[V
    if ( bSuccess ) {
        std::cout << "Lu[VB[U[:" << nId << std::endl;
        capability.StartTracking(nId);
    }
    // Lu[Vs
    else {
        std::cout << "Lu[VsB[U[:" << nId << std::endl;
    }
}

void XN_CALLBACK_TYPE SessionStart(const XnPoint3D& pfocus, void* UserCxt)
{
	cout << "Session Start" << endl;
}

void XN_CALLBACK_TYPE SessionEnd( void* UserCxt)
{
	cout << "Session End" << endl;
}

void XN_CALLBACK_TYPE Wave( void* pUserCxt)
{
	cout << "WAVE" << endl;
}


#endif