#include "Kinect.h"
#include <sstream>
#include <iostream>
#include <stdexcept>
#include <pcl/io/pcd_io.h>
#include <pcl/point_types.h>
#include <pcl/visualization/pcl_visualizer.h>
#include <boost/thread/thread.hpp>

using namespace std;

const int Kinect::Width = 640;
const int Kinect::Height = 480;

Kinect::Kinect():
	Image_Generator(0),
	Depth_Generator(0),
	ImageMD(0),
	Color_Image(0),
	DepthMD(0),
	Depth_Image(0),
	Kinect_ID(0),
	Intrinsic_Matrix(0){}
//AhX0ăANZXᔽh
Kinect::~Kinect(){
	delete   Image_Generator;
	delete   Depth_Generator;
	delete     	     ImageMD;
	delete       Color_Image;
	delete  	     DepthMD;
	delete  	 Depth_Image;
	delete	Intrinsic_Matrix;
	Image_Generator = 0;
	Depth_Generator = 0;
	ImageMD = 0;
	Color_Image = 0;
	DepthMD = 0;
	Depth_Image = 0;
	Intrinsic_Matrix = 0;
}
void Kinect::SetImageGenerator(xn::ImageGenerator* image_generator){
	Image_Generator = image_generator;
}
void Kinect::SetDepthGenerator(xn::DepthGenerator* depth_generator){
	Depth_Generator = depth_generator;
}
void Kinect::SetKinectID(int kinect_id){
	Kinect_ID = kinect_id;
}
xn::DepthMetaData*  Kinect::GetDepthMD()const{
	return DepthMD;
}

cv::Mat_<cv::Vec3b>* Kinect::GetColorImage()const{
	return Color_Image;
}
cv::Mat_<cv::Vec3b>* Kinect::GetDepthImage()const{
	return Depth_Image;
}
cv::Mat_<double>* Kinect::GetIntrinsicMatrix()const{
	return Intrinsic_Matrix;
}
int Kinect::GetKinectID()const{
	return Kinect_ID;
}
void Kinect::ProjectToReal(XnPoint3D& proj, XnPoint3D& real){
	Depth_Generator->ConvertProjectiveToRealWorld(1, &proj, &real);
}
void Kinect::RealToProject(XnPoint3D& real, XnPoint3D& proj){
	Depth_Generator->ConvertRealWorldToProjective(1, &real, &proj);
}
void Kinect::InitAllData(){

	// fvX̍WC[Wɍ킹
	xn::AlternativeViewPointCapability viewPoint =
		Depth_Generator->GetAlternativeViewPointCap();
	//r[|Cg@\擾
	//r[|Cgw肵m[hɍ킹
	viewPoint.SetViewPoint(*Image_Generator);
	//depthMD쐬
	DepthMD = new xn::DepthMetaData();
	//imageMD쐬
	ImageMD = new xn::ImageMetaData();
	//RGB摜̍쐬
	XnMapOutputMode outputmode;
	Image_Generator->GetMapOutputMode(outputmode);
	//Color摜̍쐬
	Color_Image = new cv::Mat_<cv::Vec3b>(Kinect::Height, Kinect::Width);
	//Depth摜̍쐬
	Depth_Image = new cv::Mat_<cv::Vec3b>(Kinect::Height, Kinect::Width);
	//IntrinsicMatrix
	Intrinsic_Matrix = new cv::Mat_<double>(3, 3);
	XnDouble pixel_size;
	unsigned long long F;
	Depth_Generator->GetIntProperty("ZPD", F);
	Depth_Generator->GetRealProperty("ZPPS", pixel_size);
	*Intrinsic_Matrix = (cv::Mat_<double>(3, 3) << (double)F/(double)(2.0*pixel_size), 0.0, Kinect::Width/2.0,
													0.0, (double)F/(double)(2.0*pixel_size), Kinect::Height/2.0,
														0.0, 0.0, 1.0);
}

void Kinect::UpdateAllData(){
	//imageMetadata쐬
	Image_Generator->GetMetaData(*ImageMD);
	//depthMetadata쐬
	Depth_Generator->GetMetaData(*DepthMD);
	//color_image쐬
	memcpy(Color_Image->data, ImageMD->Data(), Color_Image->step * Color_Image->rows); 
	cv::cvtColor(*Color_Image, *Color_Image, CV_RGB2BGR);
	//depthimage쐬
	CreateDepthImage();
}

void Kinect::CreateDepthImage(){
	
	//fvX̌XvZ(ASYNiSimpleViewer.cpp𗘗p)
	const int MAX_DEPTH = Depth_Generator->GetDeviceMaxDepth();
	//fvX̍ől擾
	std::vector<float> depth_hist(MAX_DEPTH);

	unsigned int points = 0;
	//points fvXƂꂽS_̐
	const XnDepthPixel* pDepth = DepthMD->Data();
	for (XnUInt y = 0; y < DepthMD->YRes(); ++y) {
		for (XnUInt x = 0; x < DepthMD->XRes(); ++x, ++pDepth) {
			if (*pDepth != 0) {
				//depth_hist[*pDepth]++;
				//std::cout << depth_data[y*Image_Size->width+x]<< std::endl;
				depth_hist[*pDepth]++;
				points++;
			}
			//fvXƂꂽpDeptḧʒũfvX̒lԖڂ̃qXgOJEg
			//fvXƂꂽ_̐JEg
		}
	}

	for (int i = 1; i < MAX_DEPTH; ++i) {
		depth_hist[i] += depth_hist[i-1];
		//S̃fvXl̃qXgO̒lɂĂl̂̒lZ
		//ɂfvX̑傫Ȓl̃qXgO͑傫ȒlɂȂ
	}

	if ( points != 0) {
		for (int i = 1; i < MAX_DEPTH; ++i) {
			depth_hist[i] =
				(unsigned int)(256 * (1.0f - (depth_hist[i] / points)));
			//fvX傫̂قǏqXgO蓖Ă
			//std::cout << depth_hist[i] << std::endl;
		}
	}

	for(int y=0; y < DepthMD->YRes(); y++){
		for(int x=0; x < DepthMD->XRes(); x++){
			Depth_Image->at<cv::Vec3b>(y, x) = cv::Vec3b(0, depth_hist[(*DepthMD)(x, y)], depth_hist[(*DepthMD)(x, y)]); 
		}
	}
}

void Kinect::VisualizationPcdFile(string pathTofile)
{
	boost::shared_ptr<pcl::visualization::PCLVisualizer> viewer_input (new pcl::visualization::PCLVisualizer ("Input Viewer"));
	viewer_input->initCameraParameters ();

	pcl::PointCloud<pcl::PointXYZRGB>::Ptr input( new pcl::PointCloud<pcl::PointXYZRGB>);


	pcl::io::loadPCDFile<pcl::PointXYZRGB>(pathTofile, *input);
	pcl::visualization::PointCloudColorHandlerRGBField<pcl::PointXYZRGB> rgb_input(input);
	viewer_input->addPointCloud<pcl::PointXYZRGB> (input, rgb_input, "input1");
	viewer_input->setPointCloudRenderingProperties (pcl::visualization::PCL_VISUALIZER_POINT_SIZE, 1.5, "input1");


	bool ShouldRun = true;
	while (ShouldRun) {  
		viewer_input->spinOnce (100);

		boost::this_thread::sleep (boost::posix_time::microseconds (100000));
	}

	return;

}

void Kinect::SavePointcloud(double range_near, double range_far){

	//J[摜Ƌ摜3_Q쐬ۑ
	//̍ہCrange_nearrange_far̊Ԃɂ_Q݂̂ۑ


	//e_̏i1_(x, y, z)(R, G, B)̏j
	pcl::PointXYZRGB points;

	//擾_Qipcl::PointXYZRGB̏Wj
	//C[WƂĂpointsǂǂcloudɒǉĂ
	pcl::PointCloud<pcl::PointXYZRGB> cloud;
	

	//ϊp3Wp
	XnPoint3D proj, real;


	//@摜yWǂ
	///////////////////ɏ//////////////////////////////
	for(int y = 0; y < ; y++){
	///////////////////ɏ//////////////////////////////
	

		//A摜xWǂ
		///////////////////ɏ//////////////////////////////
		for(int x = 0; x < ; x++){
		///////////////////ɏ//////////////////////////////


			//B摜W(x, y)ł̋̒l擾
			///////////////////ɏ//////////////////////////////
			double depth_tmp = ;
			///////////////////ɏ//////////////////////////////


			//C̒lrange_nearrange_far̊Ԃɂ
			//C̒l[mm]range_nearrange_far[m]
			///////////////////ɏ//////////////////////////////
			if( ){ 
			///////////////////ɏ//////////////////////////////


				//DϊD摜WƋ̒lprojɓo^
				///////////////////ɏ//////////////////////////////
				proj.X = ;
				proj.Y = ;
				proj.Z = ;
				///////////////////ɏ//////////////////////////////


				//EEW֕ϊ
				///////////////////ɏ//////////////////////////////
				
				///////////////////ɏ//////////////////////////////
				

				//F3_(x, y, z)(R, G, B)̏o^
				//C(x, y, z)[m]double^C(R, G, B)unsigned char^
				///////////////////ɏ//////////////////////////////
				points.x = ;
				points.y = ;
				points.z = ;
				points.b = ;
				points.g = ;
				points.r = ;
				///////////////////ɏ//////////////////////////////


				//pointcloudɊi[
				cloud.push_back(points);
			}
		}
	}

	//cloudpcdt@CƂĕۑ
	pcl::io::savePCDFile("input_points.pcd", cloud);
}

SingleKinect::SingleKinect(){
	//ContextGeneratoȑ
	Registration();
	//membeȑ
	InitAllData();
}

SingleKinect::~SingleKinect(){
	delete Kinect_Context;
	Kinect_Context = 0;
}
void SingleKinect::UpdateContextAndData(){
	Kinect_Context->WaitAndUpdateAll();
	UpdateAllData();
}
void SingleKinect::ShowImage(){


	//b֍u2Tڗp@ۑ
	//̊֐ĂD


	bool ShouldRun = true;
	char key;
	while( ShouldRun ){
		//f[^XV҂
		Kinect_Context->WaitAndUpdateAll();

		//@while[v邽тKinectf[^čXVD
		//̓Iɂ́C
		//xn::ImageGeneratorĩNXłImage_Generatorjgxn::ImageMetaDataĩNXłImageMDjɃJ[̃f[^o^
		//xn::DepthGeneratorĩNXłDepth_Generatorjgxn::DepthMetaDataĩNXłDepthMDjɋ̃f[^o^
		//ImageMDMat^̃J[摜ĩNXłColor_Imagej쐬
		//DepthMDMat^̋摜ĩNXłDepth_Imagej쐬
		//D
		//iLĂĂ郁o֐̂ŒTĂIj
		///////////////////ɏ//////////////////////////////
		
		///////////////////ɏ//////////////////////////////



		//AJ[摜\
		///////////////////ɏ//////////////////////////////
		
		///////////////////ɏ//////////////////////////////
		

		//L[͂҂
		key = cv::waitKey(1);


		//B摜\
		///////////////////ɏ//////////////////////////////
		
		///////////////////ɏ//////////////////////////////
		

		//L[͂҂
		key = cv::waitKey(1); 


		//C"s"ꂽJ[摜3_Qۑ

		//͂ꂽL["s"
		///////////////////ɏ//////////////////////////////
		if( ){ 
		///////////////////ɏ//////////////////////////////


			//"color_image.jpg"ƂOŃJ[摜ۑ
			//"save color_image"ƕWo͂ɕ\
			///////////////////ɏ//////////////////////////////
			

			///////////////////ɏ//////////////////////////////



			//0m10m͈̔͂3_Qipoint cloudjۑ
			//i܂SavePointcloud֐w肵Ďsj
			//"save pointcloud"ƕWo͂ɕ\
			///////////////////ɏ//////////////////////////////
			

			///////////////////ɏ//////////////////////////////


			ShouldRun = false;
		}
	}
}

void SingleKinect::Registration(){
	// ReLXg̏
	Kinect_Context = new xn::Context();
	XnStatus rc = Kinect_Context->InitFromXmlFile("SamplesConfig.xml");
	if (rc != XN_STATUS_OK) {
		throw std::runtime_error(xnGetStatusString(rc));
	}

	// C[WWFl[^̍쐬
	Image_Generator = new xn::ImageGenerator();
	//w肵m[h̃CX^X쐬
	rc = Kinect_Context->FindExistingNode(XN_NODE_TYPE_IMAGE, *Image_Generator);
	if (rc != XN_STATUS_OK) {
		throw std::runtime_error(xnGetStatusString(rc));
	}

	// fvXWFl[^̍쐬
	Depth_Generator = new xn::DepthGenerator();
	//w肵m[h̃CX^X쐬
	rc = Kinect_Context->FindExistingNode(XN_NODE_TYPE_DEPTH, *Depth_Generator);
	if (rc != XN_STATUS_OK) {
		throw std::runtime_error(xnGetStatusString(rc));
	}

}
